图是一种无处不在的数据结构，广泛应用于计算机科学和相关领域。 社交网络、分子图结构、生物蛋白质-蛋白质网络、推荐系统——所有这些领域以及更多领域都可以很容易地建模为图，它捕获单个单元（即节点）之间的交互（即边）。 由于其无处不在，图是无数系统的支柱，允许有效存储和访问有关交互实体的关系知识 [2]。

然而，图不仅可用作结构化知识库：它们还在现代机器学习中发挥关键作用。 许多机器学习应用程序试图使用图结构数据作为特征信息进行预测或发现新模式。 例如，人们可能希望在生物相互作用图中对蛋白质的作用进行分类，预测一个人在协作网络中的作用，在社交网络中向用户推荐新朋友，或预测现有药物分子的新治疗应用 ，其结构可以用图表示。

图1：如果相应的字符相互作用，则连接从LES磁性磁选小说的角色字符交互图的两种不同视图，其中连接两个'节点。 左图中的着色强调了图表中节点的全局位置的差异：如果它们属于全局级别，则节点具有相同的颜色。 相反，右图中的着色表示节点之间的结构等值，或者两个节点在其本地邻域中播放类似的角色（例如，“桥接节点”是彩色的蓝色）之间的结构等效。 使用Node2Vec节点嵌入方法[28]的不同设置生成两个图的着色，在第2节中描述了2.从[28]中重新打印。

图机器学习的核心问题是找到一种方法将有关图结构的信息整合到机器学习模型中。 例如，在社交网络中的链接预测的情况下，人们可能希望对节点之间的成对属性进行编码，例如关系强度或共同朋友的数量。 或者在节点分类的情况下，人们可能希望包含有关节点在图中的全局位置或节点的局部图邻域结构的信息（图 1）。 从机器学习的角度来看，挑战在于没有直接的方法将这种关于图结构的高维非欧式信息编码为特征向量。

为了从图中提取结构信息，传统的机器方法通常依赖于汇总图统计数据（例如，度数或聚类系数）[6]、核函数 [58] 或精心设计的特征来测量局部邻域结构 [40]。 然而，这些方法是有限的，因为这些手工设计的特征是不灵活的——即它们不能在学习过程中适应——并且设计这些特征可能是一个耗时且昂贵的过程

最近，出现了大量方法来寻求学习对图的结构信息进行编码的表示。这些表示学习方法背后的想法是学习一个映射，该映射将节点或整个（子）图嵌入为低维向量空间 R d 中的点。目标是优化此映射，以便嵌入空间中的几何关系反映原始图的结构。优化嵌入空间后，学习到的嵌入可以用作下游机器学习任务的特征输入。表示学习方法与以前的工作之间的主要区别在于它们如何处理表示图结构的问题。以前的工作将此问题视为预处理步骤，使用手工设计的统计数据来提取结构信息。相比之下，表示学习方法将此问题视为机器学习任务本身，使用数据驱动的方法来学习对图结构进行编码的嵌入。

在这里，我们概述了图表示学习的最新进展，回顾了表示节点和整个子图的技术。 我们的调查试图将近年来在不同子领域和领域引起广泛关注的多个不同的研究方向合并在一起——例如，节点嵌入方法，这是数据挖掘社区的一个流行研究对象，以及图卷积网络， 这在主要的机器学习领域引起了相当大的关注。 在这样做的过程中，我们开发了一个统一的概念框架来描述各种方法并强调主要的概念区别

图 2：A，Zachary Karate Club 社交网络的图结构，如果相应的个人是朋友，则节点连接。 节点根据网络中存在的不同社区进行着色。 B，使用 DeepWalk 方法（第 2.2.2 节）[47] 从该图中生成的节点嵌入的二维可视化。 嵌入空间中节点之间的距离反映了原始图中的相似性，节点嵌入根据不同的颜色编码社区进行空间聚类。 经[47, 49]许可转载。

我们将回顾重点放在最近在机器学习和数据挖掘社区中引起极大关注的方法，特别是可扩展到海量图（例如，数百万个节点）并受到深度学习进步启发的方法。 当然，还有其他密切相关和相关的工作，我们在此不详细回顾——包括社交网络的潜在空间模型 [33]、统计关系学习的嵌入方法 [43]、流形学习算法 [38] 和几何深度学习 [7]——所有这些都涉及使用图结构数据进行表征学习。 我们建议读者参考 [33]、[43]、[38] 和 [7]，以获得对这些领域的全面概述。

### 1.1 Notation and essential assumptions

我们假设输入表示算法的主要是一个无向图G=(V,E)，与相关联的二元邻接矩阵 A。我们还假设该方法可以使用节点属性实值矩阵X（表示与节点关联的文本或元数据）。目标是使用A和X中包含的信息将节点或子图映射到一个向量z。

我们回顾的大多数方法将以无监督的方式优化此映射，仅使用 A 和 X 中的信息，而无需了解特定的下游机器学习任务。 然而，我们还将讨论一些用于监督表示学习的方法，其中模型利用分类或回归标签来优化嵌入。 这些分类标签可能与单个节点或整个子图相关联，并且是下游机器学习任务的预测目标（例如，它们可能根据图表示标记蛋白质角色或分子的治疗特性）。

## 2 Embedding nodes

我们首先讨论节点嵌入的方法，其目标是将节点编码为低维向量，这些向量总结了它们的图位置和局部图邻域的结构。 这些低维嵌入可以被视为将节点编码或投影到潜在空间中，其中该潜在空间中的几何关系对应于原始图中的交互（例如，边）[33]。 图 2 可视化了著名的 Zachary Karate Club 社交网络 [47] 的嵌入示例，其中二维节点嵌入捕获了社交网络中隐含的社区结构。

### 2.1  Overview of approaches：An encoder-decoder perspective

近年来，对节点嵌入的研究激增，导致符号、动机和概念模型的复杂多样性。 因此，在讨论各种技术之前，我们首先开发了一个统一的编码器-解码器框架，它明确地构建了这种方法多样性，并将各种方法置于同等的符号和概念基础上。

在这个框架中，我们围绕两个关键映射函数组织了各种方法：一个编码器，它将每个节点映射到一个低维向量或嵌入，以及一个解码器，它从学习的嵌入中解码有关图的结构信息（图 3） ）。 编码器-解码器思想背后的直觉如下：如果我们可以学习从编码的低维嵌入中解码高维图信息——例如图中节点的全局位置或局部图邻域的结构，那么 原则上，这些嵌入应该包含下游机器学习任务所需的所有信息。

encorder作为一个函数：
$$
ENC:V->R^d
$$
将节点映射到向量嵌入 zi ∈ R d （其中 zi 对应于节点 vi ∈ V 的嵌入）。 解码器是一个函数，它接受一组节点嵌入并从这些嵌入中解码用户指定的图统计信息。 例如，**解码器可能会根据节点的嵌入 [1, 36] 来预测节点之间边的存在**，或者它可能会在图中预测节点所属的社区 [29, 35]（图 3）。 原则上，许多解码器都是可能的； 然而，绝大多数作品都使用基本的成对解码器，
$$
DEC:R^d*R^d->R^+
$$


将节点嵌入对映射到实值节点相似性度量，量化原始图中两个节点的相似性。

 当我们将成对解码器应用于一对嵌入 (zi ,zj ) 时，我们会重建原始图中 vi 和 vj 之间的相似性，目标是优化编码器和解码器映射以最小化错误或损失， 在这次重建中：
$$
DEC(ENC(v_i),ENC(v_j))=DEC(z_i,z_j)\approx s_G(v_i,v_j)
$$
其中 sG 是用户定义的、基于图的节点之间的相似性度量，定义在图 G 上。换句话说，我们想要优化我们的编码器-解码器模型，以便我们可以从zi，zj中解码原始图 sG(vi , vj )  。 例如，可以设置 sG(vi , vj ) =Ai,j 并定义节点的相似度为 1 如果它们相邻，否则为 0 [1]，或者可以根据 vi 和 vj co 的概率定义 sG -发生在图 G 上的固定长度随机游走 [28, 47]。 在实践中，大多数方法通过最小化一组训练节点对 D 上的经验损失 L 来实现重建目标（等式 3）：
$$
L=\sum_{(v_i,v_j)\in D}l(DEC(z_i,z_j),s_G(v_i,v_j))
$$
其中l : R × R → R 是用户指定的损失函数，它测量解码（即估计的）相似度值 DEC(zi , zj ) 与真实值 sG(vi , vj ) 之间的差异。 

一旦我们优化了编码器-解码器系统，我们就可以使用经过训练的编码器为节点生成嵌入，然后可以将其用作下游机器学习任务的特征输入。 例如，可以将学习到的嵌入提供给逻辑回归分类器以预测节点所属的社区 [47]，**或者可以使用嵌入之间的距离来推荐社交网络中的友谊链接 [3, 28]**（第 2.7 讨论了进一步的应用）。

 采用这种编码器 - 解码器视图，我们沿着以下四个方法组件组织了对各种节点嵌入方法的讨论：

1. 成对相似度函数 sG : V × V → R ，定义在图 G 上。该函数测量 G 中节点之间的相似度。

2. 编码器函数 ENC，生成节点嵌入。 该函数包含许多在训练阶段优化的可训练参数。

3. 解码器函数 DEC，它从生成的嵌入中重建成对的相似度值。 该函数通常不包含可训练的参数。

4. 损失函数l，它决定了如何评估成对重建的质量以训练模型，即如何将 DEC(zi , zj ) 与真实的 sG(vi , vj ) 值进行比较。 

   

   正如我们将展示的，各种节点嵌入方法之间的主要方法区别在于它们如何定义这四个组件。

   

#### 2.1.1 Notes on optimization and implementation details

我们回顾的所有方法都涉及通过最小化类似于等式 (4) 的损失来优化编码器算法 ΘENC 的参数。在大多数情况下，使用随机梯度下降进行优化，尽管有些算法确实允许使用封闭形式的解决方案 通过矩阵分解（例如，[9]）。 但是，请注意，我们不会在这里关注优化算法，而是强调不同嵌入方法之间存在的高级差异，与优化方法的细节无关。

表 1：一些著名的浅层嵌入嵌入算法的总结。 请注意，基于随机游走的方法的解码器和相似度函数是不对称的，相似度函数 pG(vj vi) 对应于从 vi 开始的固定长度随机游走上访问 vj 的概率

## 2.2 Shallow embedding approches

大多数节点嵌入算法依赖于我们所说的浅嵌入。 对于这些浅层嵌入方法，编码器函数——将节点映射到向量嵌入——只是一个“嵌入查找”：
$$
ENC(v_i)=Zv_i
$$
其中Z是一个包含所有节点的嵌入向量的矩阵，vi ∈ IV 是一个one-hot指示向量，指示对应于节点 vi 的 Z 的列。 浅层嵌入方法的可训练参数集简单地为 ΘENC = {Z}，即直接优化嵌入矩阵 Z

这些方法很大程度上受到用于降维 [4] 和多维缩放 [37] 的经典矩阵分解技术的启发。 事实上，这些方法中的许多最初是作为分解算法而被激发的，我们在这里在编码器-解码器框架内重新解释它们。 表 1 总结了编码器-解码器框架内一些众所周知的浅层嵌入方法。 表 1 强调了如何根据 (i) 它们的解码器函数、(ii) 它们基于图的相似性度量和 (iii) 它们的损失函数来简洁地描述这些方法。 以下两节更详细地描述了这些方法，区分了基于矩阵分解的方法（第 2.2.1 节）和最近的基于随机游走的方法（第 2.2.2 节）。

#### 2.2.1 Factorization-based approaches

早期的节点表示学习方法主要集中在矩阵分解方法上，这些方法直接受到降维经典技术的启发 [4, 37]。 

拉普拉斯本征图。 最早、最著名的例子之一是拉普拉斯特征图 (LE) 技术 [4]，我们可以在编码器-解码器框架内将其视为一种浅嵌入方法，其中解码器被定义为
$$
DEC(z_i,z_j)=||z_i-z_j||_2^2
$$
其中损失函数根据节点在图中的相似性对节点对进行加权：
$$
L=\sum_{v_i,v_j\in D}DEC(z_i,z_j).s_G(v_i,v_j)
$$
内积法。 继拉普拉斯特征图技术之后，最近出现了大量基于成对内积解码器的嵌入方法：
$$
DEC(z_i,z_j)=z_i^Tz_j
$$
图 4：基于随机游走的方法从每个节点 vi 开始采样大量固定长度的随机游走。 然后优化嵌入向量，以便两个嵌入 zi 和 zj 之间的点积或角度（大致）与从 vi 开始的固定长度随机游走上访问 vj 的概率成正比。

其中两个节点之间的关系强度与其嵌入的点积成正比。 图分解 (GF) 算法 4 [1]、GraRep [9] 和 HOPE [45] 都属于这一类。 特别是，所有这三种方法都使用内积解码器、均方误差 (MSE) 损失、
$$
L=\sum_{(v_i,v_j\in D)}||DEC(z_i.z_j)-s_G(v_i,v_j)||_2^2
$$
它们的主要区别在于所使用的节点相似性度量，即它们如何定义 sG(vi , vj )。 Graph Factorization 算法直接根据邻接矩阵（即 sG(vi , vj ) , Ai,j ）[1] 定义节点相似度； GraRep 考虑了邻接矩阵的各种幂（例如，sG(vi , vj ) ，A2 i,j ）以捕获高阶节点相似性 [9]； HOPE 算法支持一般的相似性度量（例如，基于 Jaccard 邻域重叠）[45]。 这些不同的相似度函数在建模“一阶相似度”之间进行权衡，其中 sG 直接测量节点之间的连接（即 sG(vi , vj ) , Ai,j [1]）和建模“高阶相似度”， 其中 sG 对应于更一般的邻域重叠概念（例如，sG(vi , vj ) = A2 i,j [9]）。

我们在本节中将这些方法称为矩阵分解方法，因为对所有节点求平均值，它们优化了以下形式的损失函数（大致）：
$$
L\approx ||Z^TZ-S||
$$
其中 S 是包含成对相似性度量（即 Si,j , sG(vi , vj )）的矩阵，Z 是节点嵌入矩阵。 直观地说，这些方法的目标只是学习每个节点的嵌入，使得学习到的嵌入向量之间的内积近似于节点相似性的某些确定性度量

#### 2.2.2 Random walk approaches

许多最近成功的方法也属于浅层嵌入方法类，它们基于随机游走统计学习节点嵌入。 他们的关键创新是优化节点嵌入，如果节点倾向于在图上的短随机游走中共同出现，则节点具有相似的嵌入（图 4）。 因此，这些随机游走方法不像第 2.2.1 节中的方法那样使用节点相似性的确定性度量，而是使用灵活的、随机的节点相似性度量，从而在许多设置中获得了卓越的性能 [27]。

DeepWalk 和 node2vec。 与上述矩阵分解方法一样，DeepWalk 和 node2vec 依赖于浅嵌入并使用基于内积的解码器。 然而，这些方法不是尝试解码确定性节点相似性度量，而是优化嵌入以对随机游走的统计数据进行编码。 这些方法背后的基本思想是学习嵌入，以便（大致）：
$$
DEC(z_i,z_j)=\frac{e^{z_i^Tz_j}}{\sum_{ vk\in V}e^{z_i^Tz_k} }\approx PG.T(v_j|v_i)\ \ (10)
$$
s 在从 vi 开始的长度为 T 的随机游走上访问 vj 的概率，T 通常定义在范围 T ∈ {2, ..., 10} 内。 请注意，与第 2.2.1 节中的相似性度量不同，pG,T (vj|vi)随机且不对称。

更正式地说，这些方法试图最小化以下交叉熵损失：
$$
L=\sum_{(v_i,v_j)\in D}-log(DEC(z_i,z_j))
$$
其中训练集D通过采样从每个节点开始的随机游走获得（例如，每个节点vi的N对采样来自分布（vi，vj）~pG.T（vj|vi））。然而，直接评价（11）代价高昂，尤其是计算（10）时间复杂度O（|V|）。因此，DeepWalk 和 node2vec 使用不同的优化和近似来计算方程（11）中的损失。 DeepWalk 采用“分层 softmax”技术来计算归一化因子，使用二叉树结构来加速计算 [47]。 相比之下，node2vec 使用“负采样”逼近方程（11）：node2vec 使用一组随机“负样本”[28] 逼近规范化因子，而不是对整个顶点集进行归一化。

除了这些算法差异之外，node2vec 和 DeepWalk 之间的主要区别在于 node2vec 允许灵活定义随机游走，而 DeepWalk 在图上使用简单的无偏随机游走。 特别是，node2vec 引入了两个随机游走超参数 p 和 q，它们会偏置随机游走（图 5.A）。 超参数 p 控制步行立即重新访问节点的可能性，而 q 控制步行重新访问节点的单跳邻域的可能性。 通过引入这些超参数，node2vec 能够在更类似于广度优先或深度优先搜索的步行之间进行平滑插值（图 5.B）。 格罗弗等人。 发现调整这些参数允许模型在强调社区结构的学习嵌入或强调局部结构角色的嵌入之间进行权衡 [28]（另请参见图 1）。

图 5：A，说明 node2vec 如何使用 p 和 q 参数偏置随机游走。 假设步行刚从 vs 过渡到 v*，边缘标签 α 与下一个时间步走这条边的概率成正比。 B，基于广度优先搜索 (BFS) 和深度优先搜索 (DFS) 的随机游走之间的区别。 类似 BFS 的随机游走主要限于探索节点的直接（即一跳）邻域，并且通常更有效地捕获结构角色。 类似 DFS 的步行探索离节点更远的地方，对于捕获社区结构更有效。 改编自 [28]。

大规模信息网络嵌入（LINE）。 另一种非常成功的浅层嵌入方法是 LINE 方法 [54]，它不是基于随机游走而是同时进行的，并且经常与 DeepWalk 和 node2vec 进行比较。 LINE 结合了两个编码器-解码器目标，分别优化了“一阶”和“二阶”节点相似性。 一阶目标使用基于 sigmoid 函数的解码器，
$$
DEC(z_i,z_j)=\frac{1}{1+e^{-z^T_iz_j}} (12)
$$
和基于邻接的相似性度量（即 sG(vi , vj ) = Ai,j ）。 二阶编码器-解码器目标类似，但考虑两跳邻接邻域并使用与等式 (10) 相同的解码器。 一阶和二阶目标都使用从 KLdivergence 度量得出的损失函数进行优化 [54]。 因此，LINE 在概念上与 node2vec 和 DeepWalk 相关，因为它使用概率解码器和损失，但它明确分解了一阶和二阶相似性，而不是将它们组合在固定长度的随机游走中。

HARP：通过图预处理扩展随机游走嵌入。 最近，陈等人。 [13] 引入了一种称为 HARP 的“元策略”，用于通过图形预处理步骤改进各种随机游走方法。 在这种方法中，使用图粗化程序将 G 中的相关节点折叠成“超级节点”，然后在这个粗化图上运行 DeepWalk、node2vec 或 LINE。 在嵌入 G 的粗化版本后，每个超级节点的学习嵌入被用作超级节点组成节点的随机游走嵌入的初始值（在对“细粒度”版本的图进行另一轮优化）。 这个一般过程可以在不同的粗度水平上以分层方式重复，并且已被证明可以持续提高 DeepWalk、node2vec 和 LINE [13] 的性能。

随机游走思想的其他变体。 随机游走的想法也有一些进一步的扩展。 例如，Perozzi 等人。 [48] 扩展 DeepWalk 算法以使用随机游走学习嵌入，这些随机游走在每一步“跳过”或“跳跃”多个节点，从而产生类似于 GraRep [9] 的相似性度量，而 Chamberlan 等人。 [11] 修改 node2vec 的内积解码器以使用双曲线而不是欧几里得距离度量。

### 2.3 Generalized encoder-decoder architectures

到目前为止，我们回顾的所有节点嵌入方法都是浅层嵌入方法，其中编码器只是一个嵌入查找（等式 5）。 然而，这些浅层嵌入方法为每个节点独立训练独特的嵌入向量，这导致了许多缺点：

1. 编码器中的节点之间没有共享参数（即，编码器只是基于任意节点 ID 的嵌入查找）。 这在统计上可能是低效的，因为参数共享可以作为一种强大的正则化形式，而且在计算上也是低效的，因为这意味着浅嵌入方法中的参数数量必然以O(|V|)增长
2. 浅嵌入也无法在编码期间利用节点属性。 在许多大型图中，节点具有属性信息（例如，社交网络上的用户个人资料），这些信息通常包含有关节点在图中的位置和角色的信息。
3. 浅嵌入方法本质上是转导的 [29]，即它们只能为训练阶段存在的节点生成嵌入，并且它们不能为以前看不见的节点生成嵌入，除非执行额外的优化轮次来优化这些节点的嵌入 . 这对于演化图、无法完全存储在内存中的海量图或需要在训练后泛化到新图的域来说是非常有问题的。

最近，已经提出了许多方法来解决这些问题中的一些或全部。 这些方法仍然完全属于 2.1 节中概述的编码器-解码器框架，但它们与 2.2 节中的浅层嵌入方法的不同之处在于它们使用更复杂的编码器，通常基于深度神经网络，并且更普遍地依赖于结构 和图的属性。

#### 2.3.1 Neighborhood auto-encoder methods

Deep Neural Graph Representations (DNGR) [10] 和 Structural Deep Network Embeddings (SDNE) [59] 解决了上述第一个问题：与浅层嵌入方法不同，它们使用深度神经网络将图结构直接合并到编码器算法中。 这些方法背后的基本思想是它们使用自动编码器——一种众所周知的深度学习方法 [31]——来压缩有关节点局部邻域的信息（图 6）。 DNGR 和 SDNE 也不同于之前审查的方法，因为它们使用一元解码器而不是成对解码器。

在每种方法中，每个节点vi，与一个邻居向量si相关联，它对应于矩阵 S 中的 vi 行（回想一下，S 包含成对节点相似性，即 Si,j = sG(vi , vj )）。 si 向量包含 vi 与图中所有其他节点的相似性，并用作 vi 邻域的高维向量表示。 DNGR 和 SDNE 的自动编码器目标是使用 si 向量嵌入节点，以便可以从这些嵌入中重建 si 向量：
$$
DEC(ENC(s_i))=DEC(z_i)\approx s_i（13）
$$
换句话说，这些方法的损失采用以下形式：
$$
L=\sum_{v_i\in V}||DEC(z_i)-s_i||_2^2（14）
$$
类似于成对解码器，我们认为zi嵌入的维度远小于|V|（si向量的维度），所以**目标是将节点的邻域信息压缩成一个低维向量**。 对于 SDNE 和 DNGR，编码器和解码器功能由多个堆叠的神经网络层组成：编码器的每一层都降低了其输入的维数，而解码器的每一层都增加了其输入的维数（图 6；参见 [31] ] 以了解深度自编码器的概述）。

图 6：为了为节点 vi 生成嵌入，邻域自编码器方法首先提取高维邻域向量 si ∈ R，它总结了 vi 与图中所有其他节点的相似性。 然后将 si 向量送入深度自动编码器以降低其维数，从而产生低维 zi 嵌入。

SDNE 和 DNGR 的不同之处在于它们用于构建邻域向量 si 的相似度函数，以及如何优化自动编码器的确切细节。 DNGR 根据随机游走中共同出现的两个节点的逐点互信息定义 si，类似于 DeepWalk 和 node2vec。 SDNE 简单地设置 si , Ai ，即等于 vi 的邻接向量。 SDNE 还结合了自动编码器目标（方程 13）和拉普拉斯特征映射目标（方程 6）[59]。

请注意，方程（13）中的编码器取决于输入 si 向量，其中包含有关 vi 的局部图邻域的信息。 这种依赖性允许 SDNE 和 DNGR 将有关节点局部邻域的结构信息作为正则化形式直接合并到编码器中，这对于浅嵌入方法是不可能的（因为它们的编码器仅取决于节点 id）。 然而，尽管有这种改进，自编码器方法仍然受到一些严重的限制。 最突出的是，自动编码器的输入维度固定为V，这对于具有数百万个节点的图来说可能非常昂贵甚至难以处理。 此外，自编码器的结构和大小是固定的，所以 SDNE 和 DNGR 是严格转导的，不能应对演化图，也不能跨图泛化。

#### 2.3.2 Neighborhood aggregation and convolutional encoder

许多最近的节点嵌入方法旨在通过设计依赖于节点的局部邻域但不一定是整个图的编码器来解决浅层嵌入和自动编码器方法的主要局限性。 这些方法背后的直觉是，它们通过聚合来自其本地邻域的信息来为节点生成嵌入（图 7）。

图 7：邻域聚合方法中的编码概述。 为了为节点 A 生成嵌入，该模型聚合来自 A 的本地图邻居（即 B、C 和 D）的消息，反过来，来自这些邻居的消息基于从其各自邻居聚合的信息，以此类推。 展示了这个想法的“深度 2”版本（即，信息是从节点 A 周围的两跳邻域聚合的），但原则上这些方法可以是任意深度的。 在最终的“深度”或“层”，初始消息基于输入节点属性。

**与前面讨论的方法不同，这些邻域聚合算法依赖于节点特征或属性（表示为 xi ∈ R m）来生成嵌入。** 例如，社交网络可能具有文本数据（例如，个人资料信息），或者蛋白质-蛋白质相互作用网络可能具有与每个节点相关联的分子标记。 邻域聚合方法利用此属性信息来通知其嵌入。 **在没有给出属性数据的情况下，这些方法可以使用简单的图统计作为属性（例如，节点度数）[29]，或者为每个节点分配一个 one-hot 指标向量作为属性 [36, 53]。** 这些方法通常称为卷积方法，因为它们将节点表示为其周围邻域的函数，其方式类似于计算机视觉中的中心-环绕卷积核的感受野 [35].5

在编码阶段，邻域聚合方法以迭代或递归的方式构建节点的表示（伪代码见算法 1）。 首先，节点嵌入被初始化为等于输入节点属性。然后在编码器算法的每次迭代中，节点使用对向量集进行运算的聚合函数聚合其邻居的嵌入。 在这种聚合之后，每个节点都被分配了一个新的嵌入，等于它的聚合邻域向量与上次迭代的先前嵌入相结合。 最后，这个组合嵌入被馈送到一个密集的神经网络层，然后重复这个过程。 随着过程的迭代，节点嵌入包含从图的越来越远的范围聚合的信息。 然而，随着过程的迭代，嵌入的维数仍然受到限制，因此编码器被迫将所有邻域信息压缩为低维向量。 在 K 次迭代后，过程终止，最终的嵌入向量作为节点表示输出。

最近有许多方法遵循算法 1 中概述的基本程序，包括图卷积网络 (GCN) [35、36、53、56]、列网络 [50] 和 GraphSAGE 算法 [29]。 算法 1 中的可训练参数——一组聚合函数和一组权重矩阵 {Wk , ∀k ∈ [1, K]}——指定如何从节点的局部邻域中聚合信息，并且与浅嵌入方法不同（第 2.2 节） )，这些参数是跨节点共享的。 相同的聚合函数和权重矩阵用于为所有节点生成嵌入，并且只有输入节点属性和邻域结构会根据嵌入的节点而变化。 这种参数共享提高了效率（即参数维度与图的大小无关），提供正则化，并允许使用这种方法为训练期间未观察到的节点生成嵌入 [29]。

GraphSAGE、列网络和各种 GCN 方法都遵循算法 1，但主要区别在于聚合（第 4 行）和向量组合（第 5 行）的执行方式。 GraphSAGE 在第 5 行使用连接并允许通用聚合函数； 作者尝试使用元素均值、最大池化神经网络和 LSTM [32] 作为聚合器，他们发现更复杂的聚合器，尤其是最大池化神经网络，获得了显着的收益。 GCN 和列网络在第 5 行使用加权总和，在第 4 行使用（加权）元素均值。

列网络还在第 7 行之前添加了一个额外的“插值”项，设置
$$
h_v^{k'}=\alpha h_v^k+(1-\alpha)h_v^{k-1}
$$
其中 α 是作为 h k-1 v 和 h k-1 N (v) 的非线性函数计算的插值权重。 这个插值项允许模型在过程迭代时保留局部信息（即，随着 k 增加并且模型整合来自图更远范围的信息）。

原则上，GraphSAGE、列网络和 GCN 编码器可以与前面讨论的任何解码器和损失函数结合使用，并且可以使用 SGD 优化整个系统。 例如，汉密尔顿等人 [29] 使用与 node2vec 相同的解码器和损失，而 Kipf 等人[36] 使用类似于图分解方法的解码器和损失函数。

已经发现，在节点分类 [29, 35] 和链接预测 [56, 36, 53] 基准测试中，遵循算法 1 的邻域聚合编码器与其浅嵌入对应物相比可提供一致的增益。 在高层次上，这些方法解决了浅嵌入的四个主要限制，如第 2.3 节开头所述：它们将图结构合并到编码器中； 他们利用节点属性； 它们的参数维度可以在 V 中变为亚线性，并且它们可以为训练期间不存在的节点生成嵌入。

### 2.4 Incorporating task-specific supervision

迄今为止描述的基本编码器-解码器框架默认是无监督的，即模型在一组节点对上优化或训练以重建成对相似度值 sG(vi , vj )，其仅依赖于图 G。然而 ，许多节点嵌入算法——尤其是第 2.3.2 节中介绍的邻域聚合方法——也可以结合特定任务的监督 [29, 35, 53, 60]。 特别是，通常方法结合节点分类任务的监督来学习嵌入。 6 为简单起见，我们讨论节点具有关联的二元分类标签的情况，但我们描述的方法很容易扩展到更复杂的分类 设置。

假设我们有一个二元分类标签，yi ∈ Z，与每个节点相关联。 为了学习将节点映射到它们的标签，我们可以通过逻辑或 sigmoid 函数 yˆi = σ(z > i θ) 提供嵌入向量 zi ，其中 θ 是可训练的参数向量。 然后我们可以计算这些预测的类别概率和真实标签之间的交叉熵损失：
$$
L=\sum_{v_i\in V}y_ilog(\sigma (ENC(v_i)^T\theta))+(1-y_i)log(1-\sigma (ENC(v_i)^T\theta))(16)
$$
然后可以通过编码器反向传播根据等式 (16) 计算的梯度以优化其参数。 这种特定于任务的监督可以完全取代使用解码器计算的重建损失（即等式 3）[29, 35]，或者它可以与解码器损失 [60] 一起包含在内。

### 2.5 Extension to multi-modal graphs

虽然我们专注于简单的无向图，但许多现实世界的图具有复杂的多模态或多层结构（例如，异构节点和边类型），并且许多工作已经引入了应对这种异构性的策略 

#### 2.5.1 Dealing with different node and edge types

许多图包含不同类型的节点和边。 例如，推荐系统图由两个不同的层组成——用户和内容——而许多生物网络有各种各样的层，它们之间有不同的相互作用（例如，疾病、基因和药物）。

处理这个问题的一般策略是 (i) 对不同类型的节点使用不同的编码器 [12] 和 (ii) 使用特定于类型的参数扩展成对解码器 [43, 53]。 例如，在具有不同边类型的图中，标准内积边解码器（即 z>izj ≈ Ai,j ）可以替换为双线性形式 [12, 43, 53]：
$$
DEC_{\tau}(z_i,z_j)=z^TA_z\ \ \ (17)
$$
其中 τ 索引特定的边类型，Aτ 是特定于类型 τ 的边的学习参数。 方程 (17) 中的矩阵 Aτ 可以通过各种方式进行正则化（例如，约束为对角线）[53]，这在存在大量边缘类型时特别有用，例如嵌入知识的情况 图表。 事实上，关于知识图完成的文献——其目标是预测知识图中缺失的关系——包含许多用于解码大量边类型（即关系）的相关技术[43].7

最近，董等人。 [19] 还提出了一种从异构图中采样随机游走的策略，其中随机游走仅限于特定类型节点之间的转换。 这种方法允许将第 2.2.2 节中的许多方法应用于异构图，并且是对包含特定类型编码器和解码器的想法的补充。

#### 2.5.2 Tying node embeddings across layers

在某些情况下，图形有多个“层”，其中包含相同节点的副本（图 8.A）。 例如，在源自不同组织（例如，大脑或肝脏组织）的蛋白质-蛋白质相互作用网络中，一些蛋白质存在于多个组织中。 在这些情况下，跨层共享信息可能是有益的，因此节点在一层中的嵌入可以通过其在其他层中的嵌入来通知。 齐特尼克等人 [61] 为这个问题提供了一种解决方案，称为 OhmNet，它将 node2vec 与正则化惩罚相结合，将嵌入跨层联系起来。 特别地，假设我们有一个节点 vi ，它属于两个不同的层 G1 和 G2，我们可以增加这个节点上的标准嵌入损失，如下所示：

图 8：A，4 层图的示例，其中相同的节点出现在多个不同的层中。通过要求不同层中同一节点的嵌入彼此相似，可以利用这种多层结构来规范不同层的学习。 B，多层图可以表现出层次结构，其中层次结构中的非根层包含存在于其子层中的边的并集——例如，源自整个人脑的生物交互图包含以下交互的并集额叶和颞叶。可以通过在层次结构的各个级别学习嵌入来利用这种结构，并且仅在具有父子关系的层之间应用正则化。 C-E，多层图嵌入到来自不同脑组织的蛋白质-蛋白质相互作用图的示例应用； C 显示了不同组织区域之间的层次结构，而 D 和 E 显示了在脑干和全脑层生成的蛋白质嵌入。嵌入是使用多层 OhmNet 方法生成的，并使用 t-SNE 投影到二维。改编自 [61]。
$$
L(v_i)'=L(v_i)=\lambda ||z_i^{G_1}-z_i^{G_2}|| \ \ \ (18)
$$
其中 L 表示该节点的通常嵌入损失（例如，来自等式 8 或 11），λ 表示正则化强度，z G1 i 和 z G2 i 分别表示 vi 在两个不同层中的嵌入。 

齐特尼克等人。 通过利用图层之间的层次结构进一步扩展这个想法（图 8.B）。 例如，在来自各种组织的蛋白质-蛋白质相互作用图中，一些层对应于整个大区域的相互作用（例如，发生在任何脑组织中的相互作用），而其他相互作用图则更细粒度（例如，仅发生在脑组织中的相互作用） 额叶）。 为了利用这种结构，可以在层次结构的各个级别学习嵌入，并且可以在层次结构中具有父子关系的层之间递归应用公式（18）中的正则化

### 2.6 Embedding structural roles

到目前为止，我们回顾的所有方法都优化了节点嵌入，以便图中附近的节点具有相似的嵌入。 然而，在许多任务中，更重要的是学习与节点的结构角色相对应的表示，而与它们的全局图位置无关（例如，在通信或交通网络中）[30]。 2.2.2 节中介绍的 node2vec 方法为这个问题提供了一种解决方案，如 Grover 等人。 发现偏置随机游走可以让他们的模型更好地捕捉结构性角色（图 5）。 然而，最近，Ribeiro 等人。 [51] 和 Donnat 等人。 [20] 开发了节点嵌入方法，专门设计用于捕获结构角色。

里贝罗等人。 提出 struc2vec，它涉及从原始图 G 生成一系列加权辅助图 G 0 k , k = {1, 2, ...}，其中辅助图 G 0 k 捕获节点的 k 跳邻域之间的结构相似性 . 特别地，让 Rk(vi) 表示距离 vi 恰好 k 跳的节点的有序度数序列，辅助图 G0 k 中的边权重 wk(vi , vj ) 递归定义为
$$
w_k(v_i,v_j)=w_{k-1}(v_i,v_j)+d(R_k(v_i),R_k(v_j))\ \ \ (19)
$$
我们其中 w0(vi , vj ) = 0 和 d(Rk(vi), Rk(vj )) 测量有序度数序列 Rk(vi) 和 Rk(vj ) 之间的“距离”（例如，通过动态时间扭曲计算[ 51]）。 在计算这些加权辅助图后，struc2vec 对它们运行有偏的随机游走，并将这些游走用作 node2vec 优化算法的输入。

唐纳特等人。 采取一种非常不同的方法来捕捉结构角色，称为 GraphWave，它依赖于谱图小波和热核 [20]。 简而言之，我们让 L 表示图拉普拉斯 - 即，L = D - A 其中 D 包含对角线上的节点度数，A 是邻接矩阵 - 我们让 U 和 λi , i = 1...表示特征向量矩阵 和 L 的特征值。 最后，我们假设我们有一个热核 g(λ) = e -sλ，具有预定义的尺度 s。 使用 U 和 g(λ)，GraphWave 计算向量，ψvi，对应节点的结构作用，vi∈V，如
$$
\psi_{v_i}=UGU^Tv_i
$$

$$
G=diag(|g(\lambda_1),...,g(\lambda_|V|)|)
$$

vi是one-hot是对应于拉普拉斯中vi行/列的one-hot指示向量。唐纳特等人。 表明，这些ψvi矢量隐含地与拓扑量相关，例如vi的程度和k循环vi的数量。他们发现 - 通过适当的规模选择，S波图能够有效地捕获有关a的结构信息 图中的节点角色（图 9）。

### 2.7 Applications of node embeddings

节点嵌入最常见的用例是可视化、聚类、节点分类和链接预测，这些用例中的每一个都与许多应用领域相关，从计算社会科学到计算生物学

可视化和模式发现。 在 2D 界面中可视化图形的问题由来已久，其应用遍及数据挖掘、社会科学和生物学 [17]。 节点嵌入为图形可视化提供了一个强大的新范式：因为节点被映射到实值向量，研究人员可以轻松利用现有的通用技术来可视化高维数据集 [57, 55]。 例如，节点嵌入可以与 t-SNE [57] 或主成分分析 (PCA) 等众所周知的技术相结合，以生成图的 2D 可视化 [47, 54]，这对于发现社区和 其他隐藏结构（图 2 和 8）。

聚类和社区检测。 与可视化类似，节点嵌入是用于聚类相关节点的强大工具，该任务具有从计算生物学（例如，发现相关药物）到营销（例如，发现相关产品）的无数应用[23]。 同样，因为每个节点都与实值向量嵌入相关联，所以可以将任何通用聚类算法应用于学习节点嵌入的集合（例如，k-means 或 DB-scan [22]）。 这为传统社区检测技术提供了一种开放式和强大的替代方案，并且还开辟了新的方法论机会，因为节点嵌入可以捕获不同节点所扮演的功能或结构角色，而不仅仅是社区结构。

节点分类和半监督学习。 节点分类可能是用于评估节点嵌入的最常见的基准任务。 在大多数情况下，节点分类任务是半监督学习的一种形式，其中标签仅适用于一小部分节点，目标是仅基于这个小的初始种子集标记整个图。 半监督节点分类的常见应用包括根据蛋白质的生物学功能对蛋白质进行分类 [28] 和对文档进行分类，视频、网页或个人归入不同的类别/社区 [28、35、47、54]。 最近，汉密尔顿等
阿尔。 [29] 介绍了归纳节点分类的任务，其目标是对训练期间未见过的节点进行分类，例如 在进化的信息图中对新文档进行分类或推广到看不见的蛋白质-蛋白质相互作用网络。

链接预测。节点嵌入作为链接预测的特征也非常有用，其目标是预测缺失的边缘或未来可能形成的边缘 [3]。链接预测是推荐系统的核心，节点嵌入的常见应用反映了这种深层联系，包括预测社交网络中缺失的友情链接 [54] 以及用户与电影之间的亲和力 [56]。链接预测在计算生物学中也有重要的应用。许多生物相互作用图（例如，蛋白质与其他蛋白质之间，或药物与疾病之间）是不完整的，因为它们依赖于从昂贵的实验室实验中获得的数据。预测这些嘈杂图中的链接是自动扩展生物数据集和为湿实验室实验推荐新方向的重要方法 [41]。更一般地说，链接预测与统计关系学习 [24] 密切相关，其中一个常见的任务是预测知识图中实体之间缺失的关系 [43]。

## 3 embedding subgraphs

现在转向（子）图上的表示学习任务，其目标是将一组节点和边编码为低维向量嵌入。 更正式地说，目标是学习全图 G 的诱导子图 G[S] 的连续向量表示 zS ∈ R d ，其中 S ⊆ V。注意这些方法可以嵌入子图 (S ⊂ V) 以及整个图（S = V）。 然后可以使用嵌入 zS 对整个子图进行预测； 例如，人们可能会嵌入对应于不同分子的图来预测它们的治疗特性 [21]。

子图上的表示学习与图内核的设计密切相关，图内核定义了子图之间的距离度量 [58]。 也就是说，我们省略了对图内核的详细讨论，这是一个庞大而丰富的研究领域，请读者参阅 [58] 进行详细讨论。 我们回顾的方法与传统的图核文献不同，主要在于我们寻求从数据中学习有用的表示，而不是通过核函数预先指定特征表示。

本节中的许多方法都建立在第 2 节中介绍的用于嵌入单个节点的技术之上。 然而，与节点嵌入设置不同，大多数子图嵌入方法是完全监督的，用于子图分类，其目标是预测一个 与特定子图相关联的标签。 因此，在本节中，我们将关注生成 zS 嵌入的各种不同方法，假设这些嵌入是通过交叉熵损失函数馈送的，类似于等式（16）。

### 3.1 Sets of node embeddings and convolutional approaches

有几种子图嵌入技术可以看作是卷积节点嵌入算法的直接扩展（在第 2.3.2 节中描述）。 这些方法背后的基本直觉是它们将子图与节点嵌入集等同起来。 他们使用卷积邻域聚合思想（即算法 1）为节点生成嵌入，然后使用附加模块聚合对应于子图的节点嵌入集。 本节中不同方法之间的主要区别在于它们如何聚合与子图对应的节点嵌入集。

#### 3.1.1 Sum-based approaches

例如，Duvenaud 等人介绍的“卷积分子指纹”。 [21] 通过对子图中的所有单个节点嵌入求和来表示分子图表示中的子图：
$$
z_S=\sum_{v_i\in S}z_i\ \ \ (21)
$$
其中嵌入 {zi , ∀vi ∈ S} 是使用算法 1 的变体生成的。 

Dai 等人 [16] 采用了一种类似的基于和的方法，但请注意它与均值场推理有概念上的联系：如果图中的节点被视为图形模型中的潜在变量，则算法 1 可以被视为一种形式的均值场推断，其中消息传递操作已被可微神经网络替代方案取代。 受这种联系的启发，戴等人。 [16] 还提出了一种基于 Loopy Belief Propagation [42] 的改进编码器。 使用算法 1 中的占位符和符号，此替代方案背后的基本思想是构建中间嵌入 ηi,j ，对应于边 (i, j) ∈ E：
$$
\eta_{i,j}^k=\sigma(W_{\varepsilon}^k\cdot COMBINE(x_i,AGGREGATE(\eta_{i,j}^{k-1},v_i\in N(v_i)\v_j)))
$$
然后聚合这些边嵌入以形成节点嵌入：
$$
z_i=\sigma(W_B^k\cdot COMBINE(x_i,AGGREGATE(\{\eta_{i,j}^k,v_i\in N(v_i) \})))
$$


#### 3.1.2 Graph-coarsening approaches

## 4 Conclusion and future directions

图上机器学习的表示学习方法为传统特征工程提供了强大的替代方案。 近年来，这些方法一直在推动节点分类和链接预测等任务的最新进展。 然而，还有很多工作要做，包括提高这些方法的性能，而且——也许更重要的是——开发一致的理论框架，未来的创新可以以此为基础。

### 4.1 Challenges to future progress

在这篇综述中，我们试图统一一些以前的工作，但该领域作为一个整体仍然缺乏一个一致的理论框架——或一组框架——来精确地描述图上表示学习的目标。目前，大多数作品的隐含目标是生成在特定分类或链接预测基准集上表现良好的表示（并且可能还生成定性令人满意的可视化）。然而，不同基准和概念模型的不受限制的扩散给未来的进步带来了真正的风险，而且这个问题只会因节点和图嵌入技术在机器学习和数据挖掘社区中不同且有些不相关的子领域的流行而加剧.作为一个领域向前发展将需要新的理论工作来更准确地描述我们期望学习的表示编码的图结构类型，我们期望模型如何编码这些信息，以及应该施加哪些约束（如果有的话）这些学习到的潜在空间。

更成熟的理论基础不仅会使该领域的研究人员受益——例如，通过告知一致且有意义的基准任务——这些基础还将允许应用领域专家更有效地选择和区分各种方法。 当前的方法通常在各种不同的基准上进行评估，这些基准强调各种不同的图属性（例如，社区结构、节点之间的关系强度或结构角色）。 然而，许多现实世界的应用程序更加专注，并且没有必要拥有对各种任务通用的表示。 作为一个领域，我们需要明确什么时候应该使用什么方法，并且规定这样的用例需要更精确的理论理解我们学习到的表示究竟是编码什么。

### 4.2 Important open problems

除了上面概述的一般挑战之外，在图表示学习领域还有许多具体的开放性问题有待解决。 

可扩展性。 虽然我们审查的大多数工作在理论上具有高度可扩展性，但是在将节点和图嵌入方法扩展到真正庞大的数据集（例如，数十亿个节点和边）方面，仍有大量工作要做。 例如，大多数方法依赖于训练和为每个单独的节点存储一个独特的嵌入。 此外，大多数评估设置都假设用于训练和测试的所有节点的属性、嵌入和边列表都可以放入主内存中——这一假设与大多数应用领域的现实不一致，其中图是巨大的、不断发展的 ，并且通常以分布式方式存储。开发真正可扩展到实际生产环境的表征学习框架对于防止学术研究界与这些方法的应用程序消费者之间的脱节扩大是必要的。

解码高阶图案。 虽然近年来的许多工作都致力于改进和改进用于生成节点嵌入的编码器算法，但大多数方法仍然依赖于基本的成对解码器，它预测节点之间的成对关系并忽略涉及两个以上节点的高阶图结构。 众所周知，高阶结构模体对于复杂网络的结构和功能至关重要 [5]，开发能够解码复杂模体的解码算法是未来工作的重要方向

建模动态时间图。 许多应用领域涉及高度动态的图，其中时间信息至关重要——例如，即时消息网络或金融交易图。 然而，我们缺乏可以应对时间图带来的独特挑战的嵌入方法，例如合并关于边的时间信息的任务。 时间图正成为越来越重要的研究对象 [46]，扩展图嵌入技术以对其进行操作将开辟广泛的令人兴奋的应用领域

关于大量候选子图的推理。 当前子图嵌入方法的一个主要技术限制是它们需要在学习过程之前预先指定目标子图。 然而，许多应用程序寻求发现具有某些属性的子图，并且这些应用程序需要能够在可能的候选子图的组合大空间上进行推理的模型。 例如，人们可能想要发现基因调控网络中的中心子图，或者发现社交网络中的邪恶子社区。 我们需要改进的子图嵌入方法，可以有效地推理大量候选子图，因为这种改进对于将子图嵌入的实用性扩展到基本子图分类任务之外至关重要。

提高可解释性。 表征学习很有吸引力，因为它减轻了手工设计特征的大部分负担，但它也以众所周知的可解释性为代价。 我们知道基于嵌入的方法提供了最先进的性能，但这些算法的基本限制和可能的潜在偏见相对未知。 为了向前发展，除了可视化和基准评估之外，还必须注意开发新技术以提高学习表示的可解释性。 鉴于这些方法的复杂性和表示能力，研究人员必须时刻保持警惕，以确保他们的方法真正学会了表示相关的图信息，而不仅仅是利用基准的统计趋势。

